package fr.bouget.metier;

import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;

import fr.bouget.connection.AccesBD;
import fr.bouget.model.Avion;
import fr.bouget.model.Pilote;
import fr.bouget.model.Vol;

public class Requetes {
	
	/**
	 * Mthode ajouter un nouveau pilote
	 * @param pilote
	 * @throws SQLException
	 */
	public static void ajouterPilote(Pilote pilote) throws SQLException
	{
		PreparedStatement prepareStatement = AccesBD.getConnection().prepareStatement("INSERT INTO `pilote` VALUES( ? , ? , ? )");
		prepareStatement.setInt(1,pilote.getId());
		prepareStatement.setString(2,pilote.getNom());
		prepareStatement.setString(3,pilote.getSite());
		prepareStatement.executeUpdate();
		
	}
	
	/**
	 * mthode pour modifier un pilote
	 * @param pilote
	 * @throws SQLException
	 */
	public static void modifierPilote(Pilote pilote) throws SQLException
	{
		try {
			PreparedStatement prepareStatement = AccesBD.getConnection().prepareStatement("UPDATE pilote SET PI_NOM = ? , PI_SITE = ? WHERE PI_ID = ? ");
			prepareStatement.setString(1,pilote.getNom());
			prepareStatement.setString(2,pilote.getSite());
			prepareStatement.setInt(3,pilote.getId());
			prepareStatement.executeUpdate();
			System.out.println("Modification effectue pour le pilote : "+pilote);

		}
		catch(SQLException e){
			System.out.println("Erreur lors de la modification !");
		}
	}
	
	public static void supprimerPilote(Pilote pilote) throws SQLException
	{
		Statement statement = null;

		try {
			statement = AccesBD.getConnection().createStatement();
			String sql = "DELETE FROM pilote WHERE PI_ID="+pilote.getId();
			statement.executeUpdate(sql);
			System.out.println("Suppression du pilote "+ pilote+ " effectue");
		}
		catch(SQLException e){
			System.out.println("Erreur lors de la suppression du pilote !");
		}
	}
	
	/**
	 * Mthode pour retourner tous les pilotes dans un tableau
	 * @return
	 * @throws ClassNotFoundException
	 * @throws SQLException
	 */
	public static ArrayList<Pilote> getAllPilotes() throws ClassNotFoundException, SQLException

	{
		ArrayList<Pilote>  pilotes = new ArrayList<Pilote>();
		String requete	= "SELECT * FROM pilote ORDER BY PI_ID";
		ResultSet resultat = AccesBD.executerQuery(requete);
		while(resultat.next())
		{
			Pilote p = Mapping.mapperPilote(resultat);
			pilotes.add(p);
		}
		return pilotes;
	}
	
	// faites la mme chose avec AVION
	public static void ajouterAvion(Avion avion)
	{
		
	}
	// faites la mme chose avec Vol (attention, un peu compliqu !!!)
	public static void ajouterVol(Vol vol)
	{
		
	}
	
	// faites la mme chose que pour modifierPilote()
	public static void modifierAvion(Avion avion)
	{
			
	}

	public static ArrayList<Vol> getAllVols() throws ClassNotFoundException, SQLException
	{
		ArrayList<Vol> vols = new ArrayList<Vol>();
		String requete = "SELECT * FROM vol";
		ResultSet resultat = AccesBD.executerQuery(requete);
	
		while(resultat.next())
		{
			Vol vol = Mapping.mapperVol(resultat);
			vols.add(vol);
		}
		
		return vols;
	}
	
	/**
	 * Mthode qui retourne une liste d'objets de type Avion
	 * @return
	 * @throws ClassNotFoundException
	 * @throws SQLException
	 */
	public static ArrayList<Avion> getAllAvions() throws ClassNotFoundException, SQLException

	{
		ArrayList<Avion>  avions = new ArrayList<Avion>();
		String requete	= "SELECT * FROM avion ORDER BY AV_ID";
		ResultSet resultat = AccesBD.executerQuery(requete);
		while(resultat.next())
		{
			Avion avion = new Avion();
			avion.setId(resultat.getInt("AV_ID"));
			avion.setConstructeur(resultat.getString("AV_CONST"));
			avion.setModele(resultat.getString("AV_MODELE"));
			avion.setCapacite(resultat.getInt("AV_CAPACITE"));
			avion.setSite(resultat.getString("AV_SITE"));
			avions.add(avion);
			
		}
		return avions;
	}
	
	/**
	 * Mthode qui retourne un objet de type Avion en fonction de son identifiant
	 * @param id
	 * @return
	 * @throws ClassNotFoundException
	 * @throws SQLException
	 */
	public static Avion getAvionById(int id) throws ClassNotFoundException, SQLException

	{
		
		Avion avion = new Avion();
		
		PreparedStatement aPreparedStatement = AccesBD.getConnection().prepareStatement("SELECT * FROM avion WHERE AV_ID = ?");
		aPreparedStatement.setInt(1,id);
		ResultSet resultat = aPreparedStatement.executeQuery();
		resultat.next();
		avion.setId(resultat.getInt("AV_ID"));
		avion.setConstructeur(resultat.getString("AV_CONST"));
		avion.setModele(resultat.getString("AV_MODELE"));
		avion.setCapacite(resultat.getInt("AV_CAPACITE"));
		avion.setSite(resultat.getString("AV_SITE"));
		return avion;
			
		}
	
	/**
	 * Mthode idem que ci-dessus avec Mapping dlgu  une mthode qui retourne un objet de type Avion en fonction de son identifiant
	 * @param id
	 * @return
	 * @throws ClassNotFoundException
	 * @throws SQLException
	 */
	public static Avion getAvionByIdAvecMapping(int id) throws ClassNotFoundException, SQLException

	{
		PreparedStatement aPreparedStatement = AccesBD.getConnection().prepareStatement("SELECT * FROM avion WHERE AV_ID = ?");
		aPreparedStatement.setInt(1,id);
		ResultSet resultat = aPreparedStatement.executeQuery();
		resultat.next();
		
		return Mapping.mapperAvion(resultat);
	}
	
	
	
	/**
	 * Mthode qui retourne un objet de type Pilote en fonction de son identifiant
	 * @param id
	 * @return
	 * @throws ClassNotFoundException
	 * @throws SQLException
	 */
	public static Pilote getPiloteById(int id) throws ClassNotFoundException, SQLException

	{
		Pilote pilote = new Pilote();
		String requete	= "SELECT * FROM pilote WHERE PI_ID="+id;
		ResultSet resultat = AccesBD.executerQuery(requete);
		resultat.next();
		pilote.setId(resultat.getInt("PI_ID"));
		pilote.setNom(resultat.getString("PI_NOM"));
		pilote.setSite(resultat.getString("PI_SITE"));
		return pilote;
			
		}
	
	public static int getNombreDePilote() throws SQLException
	{
		 ResultSet resultat = AccesBD.getConnection().createStatement().executeQuery("SELECT count(*) FROM pilote");
		 resultat.next();
		 return resultat.getInt(1);
	}
	
	
	/**
	 * Dmonstration d'une mthode qui rcupre des rsultats sans les stocker dans des objets.
	 * @throws ClassNotFoundException
	 * @throws SQLException
	 */
	public static void requetesBasiquesSansObjet() throws ClassNotFoundException, SQLException

	{
		String maRequete	= "SELECT * FROM avion ORDER BY AV_ID";
		ResultSet resultat = AccesBD.executerQuery(maRequete);
		System.out.println("Requete n1 : Liste des avions dans la table Avion :\n");
		while(resultat.next())
		{
			System.out.println("Avion : "+resultat.getInt("AV_ID")+" "+
										  resultat.getString("AV_CONST")+" "+
										  resultat.getString("AV_MODELE")+" "+
										  resultat.getInt("AV_CAPACITE")+" "+
										  resultat.getString("AV_SITE"));
		}


		System.out.println("\n\nRequtes n2 : (requte prpares) Liste des avions ayant une capacit suprieure  300 passagers\n");
		PreparedStatement aPreparedStatement = AccesBD.getConnection().prepareStatement("SELECT * FROM avion where AV_CAPACITE > ?");

		aPreparedStatement.setInt(1,300);
		resultat = aPreparedStatement.executeQuery();
		while(resultat.next())
			{
				System.out.println("Avion : "+resultat.getInt("AV_ID")+" "+
											  resultat.getString("AV_CONST")+" "+
											  resultat.getString("AV_MODELE")+" "+
											  resultat.getInt("AV_CAPACITE")+" "+
											  resultat.getString("AV_SITE"));
			}

	}
	
	
	//================================= Votre partie : Categorie =======================================
	
	
	

}
